float4x4 g_view_projection_matrix;
float4x4 g_world_matrix;
float4	g_light;
float4	g_diffuse_mtrl;
float4	g_ambient_mtrl;
texture g_tex0;

sampler2D tex0 : TEXUNIT0 = sampler_state
{
     Texture = (g_tex0);
    MIPFILTER = LINEAR;
    MAGFILTER = LINEAR;
    MINFILTER = LINEAR;
};

struct OutputVS
{
	float4 posH		: POSITION;
	float2 UV		: TEXCOORD0;
	float3 Light	: TEXCOORD1;
	float3 Norm		: TEXCOORD2;
	float3 View		: TEXCOORD3;
};

OutputVS SpecularVS( float4 posL : POSITION , float3 normal : NORMAL , float2 UV : TEXCOORD0 )
{
	OutputVS outVS = (OutputVS)0;
	
	float4 posWorld = mul( posL , g_world_matrix );

	outVS.Norm = mul( normal , g_world_matrix );
	outVS.posH = mul( posWorld , g_view_projection_matrix );
	outVS.Light = g_light;
	outVS.UV = UV;
		
	outVS.View = float3( 0.0f , 0.0f , 1.0f ) - posWorld;
	
	return outVS;
}

float4 SpecularPS( float2 UV : TEXCOORD0 , float3 Light : TEXCOORD1 , float3 Norm : TEXCOORD2 ,
				   float3 View : TEXCOORD3 ) : COLOR
{
	Norm	= normalize( Norm );
	Light	= normalize( Light );
	View	= normalize( View );
	
	//Get Texture
	float4 textureColor = tex2D( tex0 , UV );

	//Calculate diffuse color amount
	float Diff = dot( Norm , Light );
	
	//Specular
	float3 halfVec = normalize( View - Light );
	float Specular = pow( max( dot( Norm , halfVec ), 0.0f ) , 32.0f );
	float SpecMat = float3( 1.0f , 0.2f , 0.2f ) * Specular;
	
	//Yes wierd return but looks nice ;D
//	return ( ( g_diffuse_mtrl * Diff ) + SpecMat + textureColor );
	return textureColor;
}

technique Default
{
	pass p0
	{
		vertexShader = compile vs_2_0 SpecularVS();
		pixelShader = compile ps_2_0 SpecularPS();
	}
}